﻿var agentAssignment = {
    context: $(".v-agentAssignment"),
    datatable: null,
    treeview: null,
    selectedGroup: null,
    isSysAdminGroup: false,
    initializeDataTable: function (groupId) {
        var quickFilter = [{ "Label": resources.LoggedInInterviewerAssignments, "AjaxParams": { "loggedInAgents": 1 }, "DisplayCondition": function (data) { return true; } }];

        this.datatable = $(".h-agentAssignment-table", this.context).a4datatable({
            advancedFilter: true,
            height: "full",
            ajaxAction: a4.getAgentAssignmentAction("GetAgentAssignments", "InterviewerAssignment"),
            ajaxParams: { "groupId": groupId },
            multiEdit: true,
            columns: [
                { "Title": resources.UserName, "Data": "AgentName", "Class": "itemName", "AdvancedFilter": true },
                { "Title": resources.Workflow, "Data": "WorkflowName", "Key": true, "Type": "numeric", "HideInSelector": true },
                { "Title": resources.LoggedIn, "Data": "AgentLoginDateTime", "Type": "datetime" },
                { "Title": resources.Status, "Data": "AgentActivityStatusEnum", "Name": "AgentActivityStatus", "Type": "enum", "EnumType": "AgentActivityStatusType" },
                { "Title": resources.CATIModule, "Data": "CATIModuleName", "Class": "itemName", "AdvancedFilter": true },
                { "Title": resources.TelephonyModule, "Data": "ProntoModuleName", "Class": "itemName", "AdvancedFilter": true }
            ],
            stateKey: "AgentAssignment",
            displayLength: 100,
            toolBar: {
                Items: [
                    { "Action": "modify", "Label": resources.AssignWorkflow, "DisplayMode": dataTables.itemDisplayMode.selected },
                    { "Action": "remove", "Label": resources.UnassignWorkflow, "DisplayMode": dataTables.itemDisplayMode.selected, DisplayCondition: function (data) { return data.AgentAssignmentAssociationId != 0; } }
                ]
            },
            contextMenuItems: [
                { "Action": "modify", "Label": resources.AssignWorkflow, "DisplayMode": dataTables.itemDisplayMode.selected },
                { "Action": "remove", "Label": resources.UnassignWorkflow, "DisplayMode": dataTables.itemDisplayMode.selected, DisplayCondition: function (data) { return data.AgentAssignmentAssociationId != 0; } }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;
                var ids = new Array(1);
                ids[0] = row.AgentId;

                switch (action) {
                    case "modify":
                        agentAssignment.addWorkflowToUsers(ids);
                        break;
                    case "remove":
                        agentAssignment.removeWorkflowOfUsers(ids);
                        break;
                }
            },
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = _.map(rows, function (row) { return row.AgentId });

                switch (action) {
                    case "modify":
                        agentAssignment.addWorkflowToUsers(ids);
                        break;
                    case "remove":
                        agentAssignment.removeWorkflowOfUsers(ids);
                        break;
                }
            },

            loadData: function (event, data) {
                for (var i = 0; i < data.result.data.length; i++) {
                    if (!data.result.data[i].CanView) {
                        data.result.data.splice(i, 1);
                    }
                }
            },

            quickFilter: {
                "DisplayMode": "buttons",
                "Items": quickFilter
            },
            localizableTexts: { "All": resources.AllInterviewerAssignments, "Search": resources.SearchInterviewerAssignments }
        });

    },

    initializeTreeView: function () {
        var conditionsCallbacks = {
        };

        var actionButtons = [];

        var customItems = [];

        if (canViewAllUsers)
            customItems.push({ Action: "all", Name: resources.AllUsers });

        if (isSysAdmin)
            customItems.push({ Action: "sysadmins", Name: resources.SysAdmins });

        this.treeview = $(".h-userGroups", this.context).a4listview({
            ajaxAction: a4.getAction("GetUserGroups", "Users", "Settings"),
            highlightFirstNode: true,
            customItems: customItems,
            draw: function (event, data) {
                var group = data.selectedNode;
                var groupId = group ? group.Id : null;

                if (agentAssignment.datatable) {
                    agentAssignment.datatable.a4datatable("option", "ajaxParams", { "groupId": groupId });
                    agentAssignment.datatable.a4datatable("refresh");
                }
                else {
                    agentAssignment.initializeDataTable(groupId);
                }

                /*var canCreate = data.isCustom ? canCreateUsers : group.CanCreate;

                $(".h-newUserMenu", users.context).toggle(!!canCreate);
                $(".h-newUserMenu .h-addUser", users.context).toggle(!!canCreate);*/
            },
            icons: null,
            selectNode: function (event, data) {
                var tableParams = {};

                if (data.isCustom) {
                    agentAssignment.selectedGroup = null;
                    tableParams.groupId = null;
                    tableParams.unassigned = (data.node.Action == "unassigned");
                    tableParams.sysadmins = (data.node.Action == "sysadmins");
                }
                else {
                    agentAssignment.selectedGroup = data.node;
                    tableParams.groupId = data.node ? data.node.Id : null;
                    tableParams.unassigned = null;
                    tableParams.sysadmins = false;
                }

                /**/if (data.selected) {
                    agentAssignment.datatable.a4datatable("option", "ajaxParams", tableParams);
                    agentAssignment.datatable.a4datatable("refresh", true);
                }

                agentAssignment.isSysAdminGroup = (data.node.Action == "sysadmins");

                /*var canCreate = data.isCustom ? canCreateUsers : data.node.CanCreate;

                $(".h-newUserMenu", users.context).toggle(!!canCreate);
                $(".h-newUserMenu .h-addUser", users.context).toggle(!!canCreate);*/
            },
            actionButtons: actionButtons,
            actionButtonClick: function (event, data) {
                var action = data.action;
                var node = data.node;

                switch (action) {
                    // Handle assigmnent specific actions here
                }
            },
            localizableTexts: { "Search": resources.SearchUserGroups }
        });
    },

    bindEvents: function () {/* TODO: a completer getAgentAssignmentAction*/ },

    addWorkflowToUsers: function (userIds) {
        modalDialog.showWindow(a4.getAction("AddWorkflowToUsers", "InterviewerAssignment", "Project", { userIds: userIds.join(",") })
            , 400, 500,
            {afterClose: function ()
                { agentAssignment.refreshContent(); }
            });
    },

    removeWorkflowOfUsers: function (userIds) {
        if (userIds.length > 0) {
            modalDialog.showConfirmDialog(confirmRemoveWorkflowResources, function () {
                a4.callServerMethod(a4.getAction("RemoveWorkflowOfUsers", "InterviewerAssignment", "Project"), { userIds: userIds },
                    function (result) {
                        agentAssignment.refreshContent();
                    });
            }, 220, 500, false, { "count": userIds.length } );
        }
    },

    refreshContent: function () {
        agentAssignment.treeview.a4listview("refresh");
    }
}

$(document).ready(function () {
    if (agentAssignment.context.length > 0) {
        agentAssignment.initializeTreeView();
        agentAssignment.bindEvents();
    }
});